rule Win32_Ransomware_WastedLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "WASTEDLOCKER"
        description         = "Yara rule that detects WastedLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "WastedLocker"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 8B EC 83 EC ?? 83 65 ?? ?? 57 68 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? 8B F8 85 FF 0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 45 ?? 53 8B 5D ?? 8D 04 41 89 45 ?? 
            C7 00 ?? ?? ?? ?? 8B 43 ?? 57 51 89 45 ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 89 45 ?? 0F 84 
            ?? ?? ?? ?? 56 8D 47 ?? 66 83 38 ?? 75 ?? 0F B7 4F ?? 66 85 C9 0F 84 ?? ?? ?? ?? 66 
            83 F9 ?? 75 ?? 66 83 7F ?? ?? 0F 84 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B F0 
            8D 14 0E B8 ?? ?? ?? ?? 3B D0 89 55 ?? 0F 83 ?? ?? ?? ?? F6 07 ?? 0F 85 ?? ?? ?? ?? 
            8B 45 ?? 85 C0 74 ?? 83 7F ?? ?? 75 ?? 39 47 ?? 0F 82 ?? ?? ?? ?? 8D 44 36 ?? 50 8D 
            47 ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 8B 4D ?? 83 C4 ?? 85 C9 74 ?? 8B 45 ?? 83 C0 ?? 50 
            E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 85 C9 74 ?? 8B 45 ?? 83 C0 ?? 50 E8 
            ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 45 ?? 03 C6 8D 44 00 ?? 83 C0 ?? 50 6A ?? FF 
            35 ?? ?? ?? ?? 89 45 ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 ?? ?? ?? ?? FF 75 ?? 6A 
            ?? 56 E8 ?? ?? ?? ?? 8B 45 ?? 8D 44 00 ?? 50 FF 75 ?? 8D 46 ?? 50 89 76 ?? 89 36 E8 
            ?? ?? ?? ?? 8B 45 ?? 89 46 ?? 8B 45 ?? 89 46 ?? 8B 07 89 46 ?? 8B 47 ?? 89 46 ?? 8B
        }

        $find_files_p2 = {
            47 ?? 89 46 ?? 8B 47 ?? 89 46 ?? 8B 47 ?? 83 C4 ?? 89 46 ?? 83 3B ?? 74 ?? 53 FF 15 
            ?? ?? ?? ?? 8D 43 ?? 8B 48 ?? 89 06 89 4E ?? 89 31 89 70 ?? FF 43 ?? 83 7B ?? ?? 74 
            ?? 8B 43 ?? 83 F8 ?? 75 ?? FF 73 ?? FF 15 ?? ?? ?? ?? 83 3B ?? 0F 84 ?? ?? ?? ?? 53 
            FF 15 ?? ?? ?? ?? EB ?? C7 45 ?? ?? ?? ?? ?? EB ?? F6 45 ?? ?? 74 ?? 8D 4C 0E ?? 3B 
            C8 73 ?? 8D 04 36 50 8D 47 ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 8B 4D ?? 8B 45 ?? 8D 04 41 
            66 83 60 ?? ?? 83 C4 ?? 83 7D ?? ?? 66 C7 00 ?? ?? 74 ?? 83 C1 ?? 51 8B 4D ?? E8 ?? 
            ?? ?? ?? 85 C0 75 ?? 8B 4D ?? FF 75 ?? 8B 45 ?? 53 FF 75 ?? 8D 44 06 ?? FF 75 ?? 50 
            51 E8 ?? ?? ?? ?? 89 45 ?? EB ?? C7 45 ?? ?? ?? ?? ?? 83 7D ?? ?? 74 ?? F6 45 ?? ?? 
            74 ?? 83 65 ?? ?? 83 7D ?? ?? 75 ?? 57 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 43 
            ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? 
            ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5E 57 6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5B EB 
            ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 5F C9 C2
        }

        $encrypt_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 FF 75 ?? 8B 3D ?? ?? ?? ?? FF 75 ?? FF D7 85 C0 
            0F 84 ?? ?? ?? ?? FF 75 ?? 8D 75 ?? E8 ?? ?? ?? ?? 83 F8 ?? 89 45 ?? 75 ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 8B D8 83 FB ?? 74 ?? F6 C3 ?? 74 ?? 83 E0 ?? 50 FF 75 ?? FF 15 ?? 
            ?? ?? ?? 85 C0 75 ?? 33 DB 85 DB 89 5D ?? 0F 84 ?? ?? ?? ?? FF 75 ?? 8D 75 ?? E8 ?? 
            ?? ?? ?? 89 45 ?? EB ?? 83 65 ?? ?? 33 C9 39 4D ?? 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 39 4D ?? 74 ?? 8B 45 ?? 8B 10 8B 40 ?? C1 65 ?? ?? 89 55 ?? 89 45 
            ?? EB ?? C7 45 ?? ?? ?? ?? ?? 89 4D ?? 89 4D ?? 8B 45 ?? 89 45 ?? 89 4D ?? 89 4D ?? 
            8B 5D ?? 33 F6 8B 45 ?? 85 C0 89 45 ?? 74 ?? 3B D8 73 ?? 89 5D ?? 2B 45 ?? 89 45 ?? 
            75 ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 89 45 ?? 8B 7D ?? 8D 45 ?? 50 57 8D 47 ?? 50 FF 75 
            ?? 8B 45 ?? 03 C6 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 03 75 ?? 85 C0 89 45 ?? 0F
        }

        $encrypt_files_p2 = {
            85 ?? ?? ?? ?? 2B 5D ?? 75 ?? EB ?? 8B 7D ?? 8B 45 ?? 0B 45 ?? 0F 84 ?? ?? ?? ?? 33 
            C0 3B 45 ?? 77 ?? 72 ?? 3B 5D ?? 73 ?? 8B C3 EB ?? 8B 45 ?? 29 45 ?? 8B 4D ?? 83 5D 
            ?? ?? 0B 4D ?? 75 ?? 8B 4D ?? 89 4D ?? 03 F0 2B D8 0F 85 ?? ?? ?? ?? 8B 45 ?? 8B 4D 
            ?? 0F AC C8 ?? C1 E9 ?? 85 C0 74 ?? B9 ?? ?? ?? ?? F7 E1 29 45 ?? 19 55 ?? 01 45 ?? 
            11 55 ?? 83 7D ?? ?? 75 ?? 8D 75 ?? E8 ?? ?? ?? ?? 85 C0 89 45 ?? 0F 84 ?? ?? ?? ?? 
            8B 7D ?? 8D 47 ?? 50 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 75 ?? 74 ?? 83 7D ?? 
            ?? 74 ?? 8B 4D ?? 8B 45 ?? 8B D1 0B D0 74 ?? 0F AC C1 ?? C1 E8 ?? 83 4F ?? ?? 89 4F 
            ?? 89 75 ?? 39 75 ?? 74 ?? FF 75 ?? FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 39 
            75 ?? 74 ?? FF 75 ?? FF 75 ?? FF 15 ?? ?? ?? ?? EB ?? 8B 45 ?? 89 45 ?? 85 DB 0F 85 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 01 75 ?? 83 55 ?? ?? E9 ?? ?? ?? ?? FF 75 ?? FF 75 ?? FF 
            D7 EB ?? FF 15 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 5F 5E 5B C9 C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}